<?php

namespace App\Jobs;

use App\Mail\Verify;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use App\Http\Controllers\Services\Registration;

class SendActivation implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    public $data;
    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($data)
    {
        $this->data = $data;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
         foreach ($this->data as $user) {
            $user = User::find($user->id);
            $user->is_send_activation=1;
            $user->update(); 
            $email = str_replace('/','&&',Hash::make($user->email));
            $password = str_replace('/','&&',$user->password);
            $subjectEmail = 'تفعيل الحساب';
            $MailNotification = new Verify($email,$password,$subjectEmail);
            Mail::to($user->email)->send($MailNotification);
        }
    }
}
